function gen_triang(N)

r1 = 26;
r2 = 58;
r3 = 17;
r4 = 39;

coordinates = ...
    [-41 -62; ...
      41 -62; ...
      41 -44; ...
      51 -42; ...
      71  42; ...
      -2.6386  57.9227; ...
      -41 -41; ...
      0 -45; ...
      -.01 -26; ...
      .01 -26; ...
      0 -62; ...
      41 10; ...
      r1*cos(0*pi/6) r1*sin(0*pi/6); ...
      r1*cos(1*pi/6) r1*sin(1*pi/6); ...
      r1*cos(2*pi/6) r1*sin(2*pi/6); ...
      r1*cos(3*pi/6) r1*sin(3*pi/6); ...
      r1*cos(4*pi/6) r1*sin(4*pi/6); ...
      r1*cos(5*pi/6) r1*sin(5*pi/6); ...
      r1*cos(6*pi/6) r1*sin(6*pi/6); ...
      r1*cos(7*pi/6) r1*sin(7*pi/6); ...
      r1*cos(8*pi/6) r1*sin(8*pi/6); ...
      r1*cos(10*pi/6) r1*sin(10*pi/6); ...
      r1*cos(11*pi/6) r1*sin(11*pi/6); ...
      r2*cos(6*pi/6) r2*sin(6*pi/6); ... 
      r2*cos(5*pi/6) r2*sin(5*pi/6); ... 
      r2*cos(4*pi/6) r2*sin(4*pi/6); ... 
      37+r3*cos(0*pi/4) 63+r3*sin(0*pi/4); ...
      37+r3*cos(1*pi/4) 63+r3*sin(1*pi/4); ...
      37+r3*cos(2*pi/4) 63+r3*sin(2*pi/4); ...
      37+r3*cos(3*pi/4) 63+r3*sin(3*pi/4); ...
      37+r3*cos(4*pi/4) 63+r3*sin(4*pi/4); ...
      37+r3*cos(5*pi/4) 63+r3*sin(5*pi/4); ...
      37+r3*cos(6*pi/4) 63+r3*sin(6*pi/4); ...
      37+r3*cos(7*pi/4) 63+r3*sin(7*pi/4); ...
      37+r4*cos(1*pi/4) 63+r4*sin(1*pi/4); ...
      37+r4*cos(2*pi/4) 63+r4*sin(2*pi/4); ...
      37+r4*cos(3*pi/4) 63+r4*sin(3*pi/4)]

elements4 = [...
      1 11 8 7 0 0 0 0 0; ...
      11 2 3 8 0 0 0 0 0; ...
      7 8 9 20 0 0 21 0 0; ...
      7 20 18 25 0 19 0 24 0; ...
      25 18 16 6 0 17 0 26 0; ...
      8 3 23 10 0 0 22 0 0; ...
      3 12 14 23 0 0 13 0 0; ...
      12 6 16 14 0 0 15 0 0; ...
      3 4 5 12 0 0 0 0 0; ...
      12 33 31 6 0 32 0 0 0; ...
      12 5 27 33 0 0 34 0 0; ...
      5 36 29 27 35 0 28 0 0; ...
      6 31 29 36 0 30 0 37 0]
  
Dirichlet = [...
      1 11 0; ...
      11 2 0; ...
      10 23 22; ...
      23 14 13; ...
      14 16 15; ...
      16 18 17; ...
      18 20 19; ...
      20 9 21; ...
      27 29 28; ...
      29 31 30; ...
      31 33 32; ...
      33 27 34]

Neumann = [ ...
      2 3 0; ...
      3 4 0; ...
      4 5 0; ...
      5 36 35; ...
      36 6 37; ...
      6 25 26; ...
      25 7 24; ...
      7 1 0; ...
      9 8 0; ...
      8 10 0]


elements3 = [];

save coordinates.dat coordinates -ASCII
save elements4.dat elements4 -ASCII
save elements3.dat elements3 -ASCII
save Dirichlet.dat Dirichlet -ASCII
save Neumann.dat Neumann -ASCII


x = 0*rand(size(coordinates,1),1);

show(coordinates,elements4,elements3,x);

axis([-100 100 -100 120])

hold on

for j = 1 : 37
 text(coordinates(j,1)+2,coordinates(j,2)+2,num2str(j))
 text(coordinates(j,1)-2,coordinates(j,2)-2,'x')       
end



function show(coordinates,elements4,elements3,x);
% Process elements with four vertices 
   K = [1,1,0,0;0,1,1,0;0,0,1,1;1,0,0,1]/2;        
   L = [-1,-1,-1,-1,2,2,2,2]/4;                    
   for j = 1 : size(elements4,1)
     J_T = find(elements4(j,:)); 
     P = zeros(9,2);
     P(J_T,:) = coordinates(elements4(j,J_T),:);    
     P(5:8,:) = P(5:8,:) + ((elements4(j,5:8)==0)' * [1,1]) .* (K * P(1:4,:));  
     P(9,:) = P(9,:) + ((elements4(j,9)==0)' * [1,1]) .* (L * P(1:8,:)); 
     n_ind = find(elements4(j,:)==0); 
     elements4(j,n_ind) = size(coordinates,1) + [1:size(n_ind,2)];
     coordinates = [coordinates;P(n_ind,:)];
   end 
   x = [x;zeros(size(coordinates,1)-size(x,1),1)];
   fractions = [4,0,0,0,0,0,0,0,0;0,4,0,0,0,0,0,0,0;...
 	 0,0,4,0,0,0,0,0,0;0,0,0,4,0,0,0,0,0;...
 	 2,2,0,0,4,0,0,0,0;0,2,2,0,0,4,0,0,0;...
 	 0,0,2,2,0,0,4,0,0;2,0,0,2,0,0,0,4,0;...
 	 1,1,1,1,2,2,2,2,4]/4;
   for j = 1 : size(elements4,1)
     r(elements4(j,:)) = fractions * x(elements4(j,:));
   end
   if ~isempty(elements4)
     triangles = [elements4(:,[1,5,9]);elements4(:,[1,9,8]);...
	   elements4(:,[5,2,6]);elements4(:,[5,6,9]);... 
	   elements4(:,[9,6,3]);elements4(:,[9,3,7]);... 
	   elements4(:,[8,9,7]);elements4(:,[8,7,4])]';
   end
% Process elements with three vertices 
   N = [1,1,0;0,1,1;1,0,1]/2;
   for j = 1 : size(elements3,1)
     K_T = find(elements3(j,:));
     P = zeros(6,2);
     P(K_T,:) = coordinates(elements3(j,K_T),:);
     P(4:6,:) = P(4:6,:) + ((elements3(j,4:6)==0)' * [1,1]) .* (N * P(1:3,:));
     n_ind = find(elements3(j,:)==0); 
     elements3(j,n_ind) = size(coordinates,1) + [1:size(n_ind,2)];
     coordinates = [coordinates;P(n_ind,:)];
   end 
   x = [x;zeros(size(coordinates,1)-size(x,1),1)];
   fractions = [2,0,0,0,0,0;0,2,0,0,0,0;0,0,2,0,0,0;...
	 1,1,0,2,0,0;0,1,1,0,2,0;1,0,1,0,0,2]/2;
   for j = 1 : size(elements3,1)
     r(elements3(j,:)) = fractions * x(elements3(j,:));
   end
   if ~isempty(elements3)
     triangles = [triangles,[elements3(:,[1,4,6]);elements3(:,[2,5,4]);... 
	     elements3(:,[3,6,5]);elements3(:,[4,5,6])]'];
   end
% Display numerical solution
 trisurf(triangles',coordinates(:,1),coordinates(:,2),r');




