// Vorlage fuer Szenen
// A. Filler, 2003
// HINWEIS: Um diese Datei als Video zu rendern, muss sich die Datei
//          Rollende-Kugel.ini IM SELBEN ORDNER BEFINDEN WIE DIESE
//          POV-RAY-DATEI. Gerendert werden muss die .ini-Datei, damit eine
//          Sequenz von Bildern fr ein Video entsteht.
// ---------------------------------------------------------------
#version 3.5;                  
#declare intervall = 1.8;       
#declare winkel =  - 60 ;    
#include "colors.inc"       
background {White}         
// ---------------------------------------------------------------


#declare schachbrett =  texture {
      pigment { checker color rgb < 0.7, 0.7, 1 >, color rgb < 0.2, 0.2, 0.2 > }
      finish { ambient 1.0    brilliance 2    diffuse 0.7    metallic
              specular 0.90    roughness 1/20    phong 0.45   reflection 0  } scale intervall*0.5 }


// Rollende Kugel
// ---------------------------------------------------------------
sphere {  <0,0,0>  0.5  texture{schachbrett}  rotate <0,0,-360*clock*6/pi> translate<-3+clock*6, 0.5, 0> }      

// ---------------------------------------------------------------------------
// Ebene
#declare silbergrau = texture { pigment { rgbt<0.3,0.3,0.3,0> }
    finish { ambient 0.0 diffuse 0.2 reflection 0.4 brilliance 1 specular 0.4 roughness 0.1 }};

plane { y, 0 texture{silbergrau} } 


// ---------------------------------------------------------------------------
// Beschreibung der Kamera
// ---------------------------------------------------------------------------

camera { orthographic
         location  <60*intervall*cos(winkel*pi/180), 20*intervall, 60*intervall*sin(winkel*pi/180)>
         right x*4/3*2.7*intervall   up y*2.7*intervall
         look_at   <0.0, -intervall/10,  0.0> 
}

// ---------------------------------------------------------------------------
// Lichtquellen
// ---------------------------------------------------------------------------

light_source { <2.5*intervall, 2*intervall, -5*intervall>  color rgb <1, 1, 1> }
light_source { <0,10*intervall,2*intervall>  color rgb <1, 1, 1> }
