// --------------------------------------------------------------------------------
// Makropaket fr die Darstellung von Vektorpfeilen, Ebenen, Koordinatenachsen,...
// Linkshndiges Koordinatensystem
// --------------------------------------------------------------------------------
// A. Filler, 2001 - 2004
// ---------------------------------------------------------------------------
#version 3.5;                                       // bentigte POV-Ray-Version
// ---------------------------------------------------------------------------
// Definition der Kamera und der Lichtquellen
camera { orthographic
         location  <60*intervall*cos(winkel*pi/180), 5*hoehe*intervall, 60*intervall*sin(winkel*pi/180)>
         right x*4/3*2.7*intervall   up y*2.7*intervall
         look_at   <0, 0,  0> 
}
light_source { <2.5*intervall, 2*intervall, -5*intervall>  color rgb <1, 1, 1> }
light_source { <0,10*intervall,2*intervall>  color rgb <1, 1, 1> }
// ---------------------------------------------------------------------------
// Makro fr die Darstellung von Ortsvektoren
// ---------------------------------------------------------------------------
#macro ortsvektor (V , textur)
#declare vektorbetrag=sqrt(V.x*V.x+V.y*V.y+V.z*V.z); // Betrag des Vektors berechnen
#if ( V.x*V.x+V.y*V.y = 0 ) 
  #declare PFEIL=union{ cylinder{<0,0,0> <0, 0, vektorbetrag-0.15*intervall> intervall/60}
               cone{ <0,0,vektorbetrag-0.15*intervall> intervall/30  <0,0,vektorbetrag> 0 }
               texture {textur}  no_shadow 
  };               
  object {PFEIL}
#else  
  #declare PFEIL=union{ cylinder{<0,0,0> <vektorbetrag-0.15*intervall, 0, 0> intervall/60}
               cone{ <vektorbetrag-0.15*intervall,0,0> intervall/30  <vektorbetrag,0,0> 0 }
               texture {textur}  no_shadow 
  };
  #declare NX=vnormalize(V);
  #declare NY=vnormalize(vcross(NX,z));
  #declare NZ=vnormalize(vcross(NX,NY));
  object {PFEIL
  matrix < NX.x , NX.y , NX.z ,
           NY.x , NY.y , NY.z ,
           NZ.x , NZ.y , NZ.z ,
           0    , 0    ,    0  >
  }
#end
#end
// ---------------------------------------------------------------------------
// Punkt (als kleines Kuegelchen) 
// ---------------------------------------------------------------------------
#macro punkt (P, textur)
sphere{<P.x,P.y,P.z>, intervall/40 texture{textur}}
#end
// ---------------------------------------------------------------------------
// Makro fr die Darstellung von Verbindungsvektoren zwischen zwei Punkten
// ---------------------------------------------------------------------------
#macro verbindungsvektor (P, Q , textur)
#declare V=Q-P;
#declare vektorbetrag=sqrt(V.x*V.x+V.y*V.y+V.z*V.z); // Betrag des Vektors berechnen
#if ( V.x*V.x+V.y*V.y = 0 ) 
  #declare PFEIL=union{ cylinder{<0,0,0> <0, 0, vektorbetrag-0.15*intervall> intervall/60}
               cone{ <0,0,vektorbetrag-0.15*intervall> intervall/30  <0,0,vektorbetrag> 0 }
               texture {textur}  no_shadow 
  };               
  object {PFEIL translate <P.x,P.y,P.z>}
#else  
  #declare PFEIL=union{ cylinder{<0,0,0> <vektorbetrag-0.15*intervall, 0, 0> intervall/60}
               cone{ <vektorbetrag-0.15*intervall,0,0> intervall/30  <vektorbetrag,0,0> 0 }
               texture {textur}  no_shadow 
  } ;
  #declare NX=vnormalize(V);
  #declare NY=vnormalize(vcross(NX,z));
  #declare NZ=vnormalize(vcross(NX,NY));
  object {PFEIL
  matrix < NX.x , NX.y , NX.z ,
           NY.x , NY.y , NY.z ,
           NZ.x , NZ.y , NZ.z ,
           P.x  , P.y  , P.z   >
  }
#end
#end
// ------------------------------------------------------------------------------------
// Makro fr die Darstellung von Pfeilen mit beliebigen Anfangspunkten
// ---------------------------------------------------------------------------
#macro vektoranpunkt (Punkt, Vektor , textur)
verbindungsvektor (Punkt, Punkt + Vektor , textur)
#end
// ---------------------------------------------------------------------------
// Makro fr die Darstellung von Strecken
// ---------------------------------------------------------------------------
#macro strecke (P, Q , textur)
#declare V=Q-P;
#declare vektorbetrag=sqrt(V.x*V.x+V.y*V.y+V.z*V.z); // Lnge der Strecke berechnen
#if ( V.x*V.x+V.y*V.y+V.z*V.z = 0 ) 
  #else
#if ( V.x*V.x+V.y*V.y = 0 ) 
  #declare Streckenzylinder=cylinder{<0,0,0> V intervall/115
               texture {textur}  no_shadow 
  };
  object {Streckenzylinder  translate <P.x,P.y,P.z>}
#else  
  #declare Streckenzylinder=cylinder{<0,0,0> <vektorbetrag, 0, 0> intervall/115
               texture {textur}  no_shadow 
  };
  #declare NX=vnormalize(V) ;
  #declare NY=vnormalize(vcross(NX,z)) ;
  #declare NZ=vnormalize(vcross(NX,NY)) ;
  object {Streckenzylinder
  matrix < NX.x , NX.y , NX.z ,
           NY.x , NY.y , NY.z ,
           NZ.x , NZ.y , NZ.z ,
           P.x  , P.y  , P.z   >
  }
#end
#end
#end
// ---------------------------------------------------------------------------
// Makro fr die Darstellung von Geraden (als sehr lange Strecken, die ber das
// Blickfeld hinausreichen 
// ---------------------------------------------------------------------------
#macro gerade (P, Q , textur)
#declare V=Q-P;
#declare vektorbetrag=sqrt(V.x*V.x+V.y*V.y+V.z*V.z); // Lnge der Strecke berechnen
#if ( V.x*V.x+V.y*V.y = 0 ) 
  #declare Streckenzylinder=cylinder{<0,0, - 100 * intervall> <0, 0, 100 * intervall> intervall/150
               texture {textur}  no_shadow 
  };
  object {Streckenzylinder  translate <P.x,P.y,P.z>}
#else  
  #declare Streckenzylinder=cylinder{< - 100 * intervall,0,0> <100 * intervall, 0, 0> intervall/150
               texture {textur}  no_shadow 
  };
  #declare NX=vnormalize(V) ;
  #declare NY=vnormalize(vcross(NX,z)) ;
  #declare NZ=vnormalize(vcross(NX,NY)) ;
  object {Streckenzylinder
  matrix < NX.x , NX.y , NX.z ,
           NY.x , NY.y , NY.z ,
           NZ.x , NZ.y , NZ.z ,
           P.x  , P.y  , P.z   >
  }
#end
#end
// ---------------------------------------------------------------------------
// "pluspunkt": Punkt mit Verbindungsstrecken zu den Achsen 
// ---------------------------------------------------------------------------
#macro pluspunkt (PK, textur)
sphere{<PK.x,PK.y,PK.z>, intervall/40 texture{textur}}
strecke( <PK.x,PK.y,PK.z>,<PK.x,0,PK.z>, texture { pigment { rgbf<0.6,0.6,0.6,0.9> } finish { ambient 0.7 diffuse 0.5 roughness 0.1 }} )
strecke(<PK.x,0,0>, <PK.x,0,PK.z>,  texture { pigment { rgbf<0.6,0.6,0.6,0.9> } finish { ambient 0.7 diffuse 0.5 roughness 0.1 }} )
strecke(<0,0,PK.z>, <PK.x,0,PK.z>, texture { pigment { rgbf<0.6,0.6,0.6,0.9> } finish { ambient 0.7 diffuse 0.5 roughness 0.1 }} )
#end
// ---------------------------------------------------------------------------
//  Makro fr die Darstellung eines Koordinatensystems mit Achsenbezeichnungen und Skaleneinteilung
// ---------------------------------------------------------------------------
#macro koordinatensystem ( achsenlaenge )
#declare kstextur = texture { pigment { rgb<0.1,0.1,0.3> }
    finish { ambient 0.0 diffuse 0.1 reflection 0.1 brilliance 1 specular 0.3 roughness 0.2 }
} ;
#declare KSFont="cyrvetic.ttf" ;
#declare KSSchriftgroesse=achsenlaenge/5 ;
#declare skalenkugelradius=achsenlaenge/70;
union{
// x-Achse:
 cylinder{-x*1.1*achsenlaenge , x*1.05*achsenlaenge, achsenlaenge/120}
 cone{ x*1.2*achsenlaenge, 0 , x*1.05*achsenlaenge, achsenlaenge/48}
 #declare Count=-achsenlaenge;
 #while (Count < achsenlaenge+1)
   sphere {<Count,0,0>, skalenkugelradius}
 #declare Count=Count+1;
 #end
// y-Achse:
 cylinder{-y*1.1*achsenlaenge , y*1.05*achsenlaenge, achsenlaenge/120}
 cone{ y*1.2*achsenlaenge, 0 , y*1.05*achsenlaenge, achsenlaenge/48}
 #declare Count=-achsenlaenge;
 #while (Count < achsenlaenge+1)
   sphere {<0,Count,0>, skalenkugelradius}
 #declare Count=Count+1;
 #end
// z-Achse:
 cylinder{-z*1.1*achsenlaenge , z*1.05*achsenlaenge, achsenlaenge/120}
 cone{ z*1.2*achsenlaenge, 0 , z*1.05*achsenlaenge, achsenlaenge/48}
 #declare Count=-achsenlaenge;
 #while (Count < achsenlaenge+1)
    sphere {<0,0,Count>, skalenkugelradius}
 #declare Count=Count+1;
 #end
// Achsenbezeichnungen:
 text{ttf KSFont "x",0.1,0  scale KSSchriftgroesse  translate <1.08*achsenlaenge,-achsenlaenge/7,0>}
 text{ttf KSFont "y",0.1,0  scale KSSchriftgroesse  translate <-achsenlaenge/8,1.09*achsenlaenge,0>}
 text{ttf KSFont "z",0.1,0  scale KSSchriftgroesse  translate <achsenlaenge/20,0,1.1*achsenlaenge>}
texture {kstextur}  
no_shadow
}
#end
// ---------------------------------------------------------------------------
//  Vereinfachtes Koordinatensystem (ks)
// ---------------------------------------------------------------------------
#declare ks = koordinatensystem (int(intervall))
// ---------------------------------------------------------------------------
// Die folgenden beiden Zeilen dienen lediglich der Kompatibilitaet mit frheren 
// Versionen der Datei anageo.inc, die Koordinatenkreuze mit Achseneinteilung 
// lediglich fr die Achsenlaengen 5 und 10 darstellen konnten.
// ---------------------------------------------------------------------------
#declare ks10 = koordinatensystem ( 10 );
#declare ks5 =  koordinatensystem ( 5 );
// ---------------------------------------------------------------------------
// Makro fr die Erzeugung von "Ebenen" als dnne Quader aus einer Gleichung in drei Variablen
// ---------------------------------------------------------------------------
#macro ebene (A,B,C,D,textur)
#if ( B = 0 ) 
 #if ( C = 0 )
  box {<-intervall/1000 , - intervall , -intervall> <intervall/1000 , intervall , intervall> 
    texture {textur}   no_shadow
    translate <-D/A,0,0> 
  }
 #else
  box {<-intervall , - intervall , -intervall/1000> <intervall , intervall , intervall/1000> 
    texture {textur}   no_shadow
    rotate <0, degrees(atan2(A,C)) ,0>
    translate <0,0,-D/C> 
  }
 #end
#else  
 #if ( A*A + C*C = 0 ) 
  box {<-intervall , - intervall/1000 , -intervall> <intervall , intervall/1000 , intervall> 
  translate <0,-D/B,0> 
  texture {textur}   no_shadow
  }
 #else
  #declare VX1 = <0,1,0>;
  #declare VX2=vnormalize(<A,B,C>);
  #declare VY=vnormalize(vcross(VX2,VX1));
  #declare VZ1=vcross(VY,VX1);
  #declare VZ2=vcross(VY,VX2);
  box {<-intervall , - intervall/1000 , -intervall> <intervall , intervall/1000 , intervall> 
  matrix < VX1.x, VY.x, VZ1.x,
           VX1.y, VY.y, VZ1.y,
           VX1.z, VY.z, VZ1.z,
               0     0      0 >
  matrix < VX2.x, VX2.y, VX2.z,
            VY.x,  VY.y,  VY.z,
           VZ2.x, VZ2.y, VZ2.z,
               0,     0,     0 >
  translate <0,-D/B,0> 
  texture {textur}   no_shadow
  }
 #end
#end
#end
// ---------------------------------------------------------------------------
// Makro fr die Erzeugung von "Ebenen" als dnne Quader aus einer Parameterdarstellung
// ---------------------------------------------------------------------------
#macro ebenepar (P,a,b,textur)
#declare normvekt = vcross(a,b);
#declare A = normvekt.x;
#declare B = normvekt.y;
#declare C = normvekt.z;
#if ( B = 0 ) 
 #if ( C = 0 )
  box {<-intervall/1000 , - intervall , -intervall> <intervall/1000 , intervall , intervall> 
    texture {textur}   no_shadow
    translate P 
  }
 #else
  box {<-intervall , - intervall , -intervall/1000> <intervall , intervall , intervall/1000> 
    texture {textur}   no_shadow
    rotate <0, degrees(atan2(A,C)) ,0>
    translate P 
  }
 #end
#else  
 #if ( A*A + C*C = 0 ) 
  box {<-intervall , - intervall/1000 , -intervall> <intervall , intervall/1000 , intervall> 
  translate P 
  texture {textur}   no_shadow
  }
 #else
  #declare VX1 = <0,1,0>;
  #declare VX2=vnormalize(<A,B,C>);
  #declare VY=vnormalize(vcross(VX2,VX1));
  #declare VZ1=vcross(VY,VX1);
  #declare VZ2=vcross(VY,VX2);
  box {<-intervall , - intervall/1000 , -intervall> <intervall , intervall/1000 , intervall> 
  matrix < VX1.x, VY.x, VZ1.x,
           VX1.y, VY.y, VZ1.y,
           VX1.z, VY.z, VZ1.z,
               0     0      0 >
  matrix < VX2.x, VX2.y, VX2.z,
            VY.x,  VY.y,  VY.z,
           VZ2.x, VZ2.y, VZ2.z,
               0,     0,     0 >
  translate P 
  texture {textur}   no_shadow
  }
 #end
#end
#end
// ---------------------------------------------------------------------------
// Definition von Materialien und Oberflchen (Texturen)
// ---------------------------------------------------------------------------
#include "colors.inc" 
#include "textures.inc"
#include "stones1.inc"
#include "metals.inc"

#declare holz = DMFWood6

#declare stein = T_Stone9

#declare silber = T_Silver_4D

#declare blau_matt = texture { pigment { color rgb < 0.3, 0.3, 1.0> }  
          finish { ambient 0.2  diffuse 0.7  phong 0.2 phong_size 20  reflection 0 } }

#declare blau_glanz = texture { pigment { color rgb < 0.1, 0.1, 1.0> }  
          finish { ambient 0.05  diffuse 0.3  phong 0.4 phong_size 50  reflection 0.4 } }
 
#declare rot_matt = texture { pigment { color rgb < 1, 0.2, 0.2> }  
          finish { ambient 0.2  diffuse 0.7  phong 0.2 phong_size 20  reflection 0 } }

#declare rot_glanz = texture { pigment { color rgb < 1, 0, 0> }  
          finish { ambient 0.05  diffuse 0.3  phong 0.4 phong_size 50  reflection 0.4 } }
 
#declare gruen_matt = texture { pigment { color rgb < 0.15, 1, 0.15> }  
          finish { ambient 0.2  diffuse 0.7  phong 0.2 phong_size 20  reflection 0 } }

#declare gruen_glanz = texture { pigment { color rgb < 0, 1, 0> }  
          finish { ambient 0.05  diffuse 0.3  phong 0.4 phong_size 50  reflection 0.4 } }

#declare mattweiss = texture { pigment { color rgb < 1, 1, 1> }  
          finish { ambient 0.6  diffuse 0.4  phong 0 reflection 0 roughness 0.8 crand 0.03} }

#declare schwarz = texture { pigment { color rgb < 0.1, 0.1, 0.1> }  
          finish { ambient 0.7  diffuse 0.5  phong 0.05 phong_size 15 reflection 0 roughness 0.8 crand 0.1} }
 
#declare silbergrau = texture { pigment { rgbt<0.3,0.3,0.3,0> }
    finish { ambient 0.0 diffuse 0.2 reflection 0.4 brilliance 1 specular 0.4 roughness 0.1 }};

#declare blau_transp = texture{ pigment{rgbf<0.4,0.4,1,0.75>} 
    finish{ ambient 1.0  diffuse 0.8  phong 0  reflection 0.0}    } 

#declare gruen_transp = texture{ pigment{rgbf<0.4,1,0.4,0.75>} 
    finish{ ambient 1.0  diffuse 0.8  phong 0  reflection 0.0}    } 

#declare rot_transp = texture{ pigment{rgbf<1,0.4,0.4,0.65>} 
    finish{ ambient 1.0  diffuse 0.8  phong 0  reflection 0.0}    } 

#declare schachbrett =  texture {
      pigment { checker color rgb < 0.7, 0.7, 1 >, color rgb < 0.2, 0.2, 0.2 > }
      finish { ambient 1.0    brilliance 2    diffuse 0.7    metallic
              specular 0.90    roughness 1/20    phong 0.45   reflection 0  } scale intervall*0.5 }

// ---------------------------------------------------------------------------
// Bereitstellung weiterer Texturen
// ---------------------------------------------------------------------------
#declare vektortextur = texture { pigment { rgbt<0.3,0.3,0.3,0.5> }
    finish { ambient 0.0 diffuse 0.2 reflection 0.1 brilliance 1 specular 0.4 roughness 0.1 }};
#declare Material_Strecke_blau =  texture{ pigment{rgb<0.1,0.1,1>} 
    finish{ambient 0.2 diffuse 0.3 phong 0.5 reflection 0.4} }    
