// Schrger Wurf
// A. Filler, 2003
// HINWEIS: Um diese Datei als Video zu rendern, muss sich die Datei
//          Schraeger-Wurf.ini IM SELBEN ORDNER BEFINDEN WIE DIESE
//          POV-RAY-DATEI. Gerendert werden muss die .ini-Datei, damit eine
//          Sequenz von Bildern fr ein Video entsteht.
// ---------------------------------------------------------------
#version 3.5;                  
#declare intervall = 3;        
#declare winkel =  - 60 ;      
background {color rgb <1,1,1>}             
// ---------------------------------------------------------------

#declare v0 = <5,5,0>;       // Anfangsgeschwindigkeit
#declare g = <0,-10,0> ;     // Fallbeschleunigung

sphere { <-2.5,0,0> + v0*clock + g/2*clock*clock  0.25   
           texture{ pigment{rgb<0.2,0.2,1>} 
           finish{ ambient 0.4  diffuse 0.7  phong 0.3 reflection 0 }} 
           no_shadow
       }


#declare i=0;
  #while (i <= 200*clock)
sphere { <-2.5,0,0> + v0*(i/200) + g/2*(i/200)*(i/200)  0.025   
           texture{ pigment{rgb<0.1,0.1,0.7>} 
           finish{ ambient 0.3  diffuse 0.4  phong 0 reflection 0 }} 
           no_shadow
       }    
  #declare i=i+1;
  #end



// ---------------------------------------------------------------------------
// Beschreibung der Kamera und der Lichtquellen
// ---------------------------------------------------------------------------
camera { location  <0,12,-100>
         angle 3.6
         look_at   <0,0,0> 
}
light_source { <8, 5, -15>  color rgb <1, 1, 1> }
light_source { <0,30,-20> }

// ---------------------------------------------------------------------------
//Grundebene
// ---------------------------------------------------------------------------
  plane { y, -0.25  texture {
    pigment { checker color rgb <0.5, 0.5, 0.5>, color rgb <0.8, 0.8, 0.8> 
              scale 1.5 }  }   
    finish { ambient 0.8  diffuse 0.8  reflection 0.2 }  } 
    


// ---------------------------------------------------------------------------
// Makro fr die Darstellung von Verbindungsvektoren zwischen zwei Punkten
// ---------------------------------------------------------------------------
#macro verbindungsvektor (P, Q , textur)
#declare V=Q-P;
#declare vektorbetrag=sqrt(V.x*V.x+V.y*V.y+V.z*V.z); // Betrag des Vektors berechnen
#if ( V.x*V.x+V.y*V.y = 0 ) 
  #declare PFEIL=union{ cylinder{<0,0,0> <0, 0, vektorbetrag-0.15*intervall> intervall/60}
               cone{ <0,0,vektorbetrag-0.15*intervall> intervall/30  <0,0,vektorbetrag> 0 }
               texture {textur}  no_shadow 
  };               
  object {PFEIL translate <P.x,P.y,P.z>}
#else  
  #declare PFEIL=union{ cylinder{<0,0,0> <vektorbetrag-0.15*intervall, 0, 0> intervall/60}
               cone{ <vektorbetrag-0.15*intervall,0,0> intervall/30  <vektorbetrag,0,0> 0 }
               texture {textur}  no_shadow 
  } ;
  #declare NX=vnormalize(V);
  #declare NY=vnormalize(vcross(NX,z));
  #declare NZ=vnormalize(vcross(NX,NY));
  object {PFEIL
  matrix < NX.x , NX.y , NX.z ,
           NY.x , NY.y , NY.z ,
           NZ.x , NZ.y , NZ.z ,
           P.x  , P.y  , P.z   >
  }
#end
#end

object{
verbindungsvektor(<-2.5,0,0>,<-2.5,0,0>+v0/4, texture { pigment { rgbt<0.3,0.3,0.3,0> }
    finish { ambient 0.0 diffuse 0.1 reflection 0.2 brilliance 1 specular 0.4 roughness 0.1 }})
translate <-0.25,-0.25,0>
}