// Bewegung einer Kugel auf einer Schraubenlinie
// A. Filler, 2003-2006
// HINWEIS: Um diese Datei als Video zu rendern, muss sich die Datei
//          Animation3-Spirale.ini IM SELBEN ORDNER BEFINDEN WIE DIESE
//          POV-RAY-DATEI. Gerendert werden muss die .ini-Datei, damit eine
//          Sequenz von Bildern fr ein Video entsteht.
// ---------------------------------------------------------------
#version 3.5;                  // bentigte POV-Ray-Version
#declare intervall = 10;        // Von der Kamera erfasster Bildausschnitt
#declare winkel =  - 60 ;      // Winkel der Kamera zur x-Achse (in Grad)
background {color rgb <1,1,1>}             // Farbe des Hintergrundes
// ---------------------------------------------------------------

sphere {  <10*cos(4*pi*clock),10*clock,10*sin(4*pi*clock)>  1   texture{ pigment{rgb<0.2,0.2,1>} 
                                           finish{ ambient 0.4  diffuse 0.7  phong 0.3 reflection 0 }} 
       no_shadow}


#declare i=0;
  #while (i <= 400*clock)
    sphere {  <10*cos(4*pi*(i/400)),10*(i/400),10*sin(4*pi*(i/400))>  0.1   texture{ pigment{rgb<0.2,0.2,1>} 
                                           finish{ ambient 0.4  diffuse 0.7  phong 0.3 reflection 0 }} 
       no_shadow}   
  #declare i=i+1;
  #end

// ---------------------------------------------------------------
// Beschreibung der Kamera und der Lichtquellen
// ---------------------------------------------------------------
camera { location  <40,40,-40>
         angle 22
         look_at   <0,5,0> 
}
light_source { <8, 5, -15>  color rgb <1, 1, 1> }
light_source { <0,30,-20> }

// --------------------------------------------------------------
//Grundebene
// --------------------------------------------------------------
  plane { y, -1  texture {
    pigment { checker color rgb <0.5, 0.5, 0.5>, color rgb <0.8, 0.8, 0.8> 
              scale 3 }  }   
    finish { ambient 0.8  diffuse 0.8  reflection 0.2 }  } 
    
// -------------------------------------------------------------
// Einfgen eines Koordinatensystems mit Achsen von -intervall bis intervall
// -------------------------------------------------------------
#macro koordinatensystem ( achsenlaenge )
#declare kstextur = texture { pigment { rgbf<0.1,0.1,0.2,0.5> }
    finish { ambient 0.0 diffuse 0.1 reflection 0.05 brilliance 1 specular 0.3 roughness 0.2 }
} ;
#declare KSFont="cyrvetic.ttf" ;
#declare KSSchriftgroesse=achsenlaenge/5 ;
union{
// x-Achse:
        cylinder{-x*1.15*achsenlaenge , x*achsenlaenge, achsenlaenge/120}
        cone{ x*1.15*achsenlaenge, 0 , x*achsenlaenge, achsenlaenge/48}
// y-Achse:
        cylinder{-y*1.15*achsenlaenge , y*achsenlaenge, achsenlaenge/120}
        cone{ y*1.15*achsenlaenge, 0 , y*achsenlaenge, achsenlaenge/48}
// z-Achse:
        cylinder{-z*1.15*achsenlaenge , z*achsenlaenge, achsenlaenge/120}
        cone{ z*1.15*achsenlaenge, 0 , z*achsenlaenge, achsenlaenge/48}
// Achsenbezeichnungen:
        text{ttf KSFont "x",0.1,0  scale KSSchriftgroesse  translate <1.18*achsenlaenge,0,0>}
        text{ttf KSFont "y",0.1,0  scale KSSchriftgroesse  translate <-achsenlaenge/7,0.96*achsenlaenge,0>}
        text{ttf KSFont "z",0.1,0  scale KSSchriftgroesse  translate <achsenlaenge/20,0,1.1*achsenlaenge>}
texture {kstextur}  no_shadow
}
#end

koordinatensystem (intervall)           