// Animierte Spotlights auf einen Schneemann
// A. Filler, 2003
// HINWEIS: Um diese Datei als Video zu rendern, muss sich die Datei
//          Scheinwerferanimation.ini IM SELBEN ORDNER BEFINDEN WIE DIESE
//          POV-RAY-DATEI. Gerendert werden muss die .ini-Datei, damit eine
//          Sequenz von Bildern fr ein Video entsteht.
// ---------------------------------------------------------------
#version 3.5;                  // bentigte POV-Ray-Version
#include "colors.inc" 
#include "textures.inc"

background {White}             // Farbe des Hintergrundes

media {scattering { 1, rgb <0.5,0.5,0.5>  extinction 0.1 } density {color rgb <0.1 0.1 0.1>} }

// ---------------------------------------------------------------
// Kamera

camera { location  <60, 30, -100>
         angle 20
         look_at   <0, 10,  0>    }  

// ---------------------------------------------------------------
// Lichtquellen

#declare alph = clock*2*pi;
#declare abst = 30 - 30*clock;

light_source { <60, 30, -100>  color rgb <1, 1, 1>  media_interaction off }
light_source { <11, 30, -10>  color rgb <1, 0, 0> spotlight point_at <abst*cos(alph),0,abst*sin(alph)> radius 6 falloff 15    area_light <4,0,0>, <0,0,4>, 3, 3 adaptive 1 jitter }
light_source { <-20, 30, 0>  color rgb <0, 1, 0> spotlight point_at <abst*cos(alph+2*pi/3),0,abst*sin(alph+2*pi/3)> radius 6 falloff 15   area_light <4,0,0>, <0,0,4>, 3, 3 adaptive 1 jitter }
light_source { <9, 30, 18>  color rgb <0, 0, 1> spotlight point_at <abst*cos(alph+4*pi/3),0,abst*sin(alph+4*pi/3)> radius 6 falloff 15   area_light <4,0,0>, <0,0,4>, 3, 3 adaptive 1 jitter }

// ---------------------------------------------------------------
// Schneemann

#declare rot_matt = texture { pigment { color rgb < 1, 0.2, 0.2> }  
          finish { ambient 0.2  diffuse 0.7  phong 0.2 phong_size 20  reflection 0 } }
#declare mattweiss = texture { pigment { color rgb < 1, 1, 1> }  
          finish { ambient 0.6  diffuse 0.4  phong 0 reflection 0 roughness 0.8 crand 0.03} }
#declare schwarz = texture { pigment { color rgb < 0.1, 0.1, 0.1> }  
          finish { ambient 0.7  diffuse 0.5  phong 0.05 phong_size 15 reflection 0 roughness 0.8 crand 0.1} } 
sphere{<0,5,0> 1.4 texture{mattweiss}}
sphere{<0,7.2,0> 1 texture{mattweiss}} 
sphere{<0,2,0> 2 texture{mattweiss}}
sphere{<0,5,-1.4> 0.2 texture{schwarz}}
sphere{<0,2,-2> 0.2 texture{schwarz}}
sphere{<0,3.1,-1.7> 0.2 texture{schwarz}}
sphere{<0.5,7.6,-0.8> 0.1 texture{schwarz}}
sphere{<-0.5,7.6,-0.8> 0.1 texture{schwarz}} 
cone{<0,7.2,0> 0.3 <-0.2,7.4,-2.2> 0 texture{rot_matt}} 
cylinder{<0,7.9,0> <0,7.95,0> 1.3 texture{schwarz}}
cylinder{<0,7.95,0> <0,9.5,0> 0.9 texture{schwarz}}

// ---------------------------------------------------------------
// Grundebene

plane{<0,1,0>,0 texture { pigment { color rgb < 1, 1, 1> }  
          finish { ambient 0.6  diffuse 0.4  phong 0 reflection 0 roughness 0.8 crand 0.03} }}   
          
